; Tiny BASIC for the F8 - Jerry D. Fox - Dr Dobbs #39 OCT 79
; modified for DASM - 6/28/2012 www.seanriddle.com
; modified for SBCF8 - 11/10/2020 Tetsuya Suzuki
; dasm f8basic.asm -f3 -of8basic.bin -Lf8basic.lst
;
UARTD	EQU	$FF00
UARTC	EQU	$FF01
ROMTOP	EQU	$0000
RAMTOP	EQU	$8000
	PROCESSOR F8
	ORG	ROMTOP
;
;	COLD START
;	8251 HARDWARE RESET
CSTART	INS	1	;READ PORT1
	NI	$7F	;CLEAR MSB
	OUTS	1	;OUT PORT1
	OI	$80	;SET MSB
	OUTS	1	;OUT PORT1
	CLR		;ESCAPE
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
	LI	$40	;SOFTWARE RESET
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
	LI	$4E	;MODE
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
	LI	$37	;COMMAND
	DCI	UARTC	;8251 CONTROL REGISTER
	ST		;OUT 8251
;
;	RND INITIALIZE
	DCI	RANPNT	;RND POINTER
	CLR		;CLEAR A
	ST		;WRITE
	ST		;WRITE
;
	JMP	NEWT	;GO SETUP TXTU
			;R3=FORMAT NUMBER
			;R4=CURRENT CHARACTER BEING PROCESSED
			;R5 IS A FLAG FOR STRINGS
			;R9 IS THE STATUS SAVE REG
			;SCRATCH STORAGE
			;26-27 TXTU    UNFILLED TEXT ADDR
			;30-31 CURRNT  CURRENT TBP
			;32-33 SKINP   SAVE INPUT STACK
			;34-35 SKGOS   SAVE GOSUB STACK
			;SAVE ORDER TOP-DOWN
			;36-37 LOPVAR  LOOP VARIABLE
			;40-41 LOPPT   TEXT POINTER
			;42-43 LOPLN   LINE NUMBER
			;44-45 LOPINC  INCREMENT
			;46-47 LOPLMT  LIMIT
			;52-53 TEMP POINTER FOR READ-DATA
			;50-51 RESTORE POINTER FOR READ-DAT
START	DCI	STACK	;SETUP
	LR	Q,DC	;STACK REG Q
	CLR		;ZERO
	LISL	7	;SCRATCH
ST1	LISU	3	;AREA
	LR	S,A	;30-37
	LISU	5	;AND
	LR	D,A	;50-57
	BR7	ST1	;30-37
	LR	5,A	;CLEAR STRING FLAG FOR DIRECT
	LISU	2	;RESET ISAR
	PI	TTCR	;CR LF
	LR	8,A	;SET FOR PRTSTG
	DCI	PROMPT	;OUTPUT
	PI	PRTSTG	;PROMPT
ST2	LI	'>	;LOAD
	LR	1,A	;PROMPT CHARACTER
	PI	GETLN	;GET A LINE
	LR	H,DC	;SAVE EOL
	LR	A,11	;LOW ORDER
	LR	6,A	;BYTE IN R6
	DCI	BUFF	;START OF LINE
	PI	TSTNUM	;SEE IF A NUMBER
	DS	1	;NUMBER ?
	BNZ	ST3	;B IF A NUMBER
	LR	H,DC	;SAVE TBP
	JMP	DIRECT	;A COMMAND
ST3	LI	<-2	;BACKUP DC
	ADC		;TO HEX LINE #
	PI	PUSHDC	;SAVE BOL
	LR	A,I	;STORE
	ST		;HEX
	LR	A,D	;LINE
	ST		;NUMBER
	LR	A,11	;LOW ORDER BYTE
	COM		;OF BEGIN
	INC		;MAKE IT -
	AS	6	;SAVE #
	LR	6,A	;OF CHARS
	PI	FNDLN	;FIND LINE #
	PI	PUSHDC	;SAVE ADDR
	XDC		;IN DC1 ALSO
	LR	DC,H	;SAVE IN DC0 ALSO
	LISL	6	;PUT TXTU
	PI	PUSHSR	;ON THE STACK TCP
			;AT THIS POINT DC0=DC1=FOUND LINE ADD
	BZ	FLINE	;B IF FOUND LINE
	BNC	NLINE	;B IF PAST TXTU
	BR	INSERT	;B IF BETWEEN 2 LINES
			;DELETE LINE POINTED TO BY DC1
			;MOVE H THRU TXTU UP
			;DC0=LINE FOLLOWING FOUND LINE
			;DC1=FOUND LINE
FLINE	LM		;GET PAST
	LM		;LINE #
	PI	FNDNXT	;FIND NEXT LINE *FROM* IN DC0
	PI	MVUP	;DELETE THE LINE
			;DC1 HAS THE UPDATED TXTU ADDR (76)
	XDC		;HAS UPDATED TXTU (77)
	LR	H,DC	;INTO H
	LISL	6	;SET ISAR TO TXTU
	LR	A,10	;NEW
	LR	I,A	;TXTU
	LR	A,11	;ADDR
	LR	D,A	;IN TXTU
	PI	POPRT	;CLEAR OLD TXTU
	PI	PUSHSR	;NEW TXTU ON THE STACK TOP
			;INSERT BETWEEN 2 LINES
INSERT	LR	A,6	;LOAD LINE LENGTH
	CI	3	;ANY TEXT?
	BZ	START	;NO JUST DELETE
			;MOVE TXTU(DC0) THRU FOUND LINE(STACK
			;TOP) TO TXTU+R4 (DC1)
	PI	TXCK	;UPDATE TXTU
	XDC		;SETUP THE MOVE
	PI	MVDOWN	;MOVE DOWN
	BR	ST4	;MOVE IN NEW LINE
			;NEW LINE
NLINE	PI	TXCK	;UPDATE TXTU
			;MOVE IN NEW LINE
			;SETUP DC0 AND DC1 FOR NEW LINE MOVE
ST4	PI	PULLDC	;*TO* FOUND LINE
	XDC		;IN DC1
	PI	PULLDC	;*FROM* FOUND LINE
ST5	LM		;LOAD A BYTE
	XDC		;SWITCH DC
	ST		;STORE IT
	XDC		;RESET DC
	DS	6	;DEC BYTE COUNT
	BNZ	ST5	;B IF MORE
	JMP	ST2	;NEXT RECORD
			;THIS ROUTINE EXITS WITH
			;DC0=NEW TXTU, DC1=OLD TXTU
			;SEE IF TXT AREA IS LEFT
			;IF ROOM UPDATE TXTU BY R4
TXCK	LR	K,P	;SAVE RETURN
	PI	PULLDC	;GET TXTU
	XDC		;SAVE TXTU IN DC1
	DCI	TXTE	;TEXT END ADDR
	PI	PUSHDC	;ON THE STACK
	XDC		;PUT
	LR	H,DC	;TXTU
	XDC		;IN
	LR	DC,H	;BOTH DC0 AND DC1
	LR	A,6	;UPDATE TXTU
	ADC		;WITH NEW LINE LENGTH
	LR	H,DC	;NEW TXTU IN 10-11
	LISL	6	;TXTU ISAR ADDR
	LR	A,10	;STORE
	LR	I,A	;NEW
	LR	A,11	;TXTU
	LR	D,A	;IN 26-27
	PI	COMT	;COMPARE TXTE-TXTU
	BC	TXC1	;B IF MORE ROOM
	JMP	ASORRY	;NO MORE ROOM
TXC1	PK		;RETURN
			;
			;OUTPUT CONTENTS OF ACCUM
			;INPUT A LINE
GETLN	LR	K,P	;SAVE RETURN
	PI	PUSHRT	;PUSH IT
	LI	72	;BUFFER
	LR	8,A	;LENGTH
	LR	A,1	;LOAD LEAD CHARACTER
GET1	DCI	BUFF	;BUFFER ADDR
GET2	LR	1,A	;OUTPUT
	PI	TTY0	;THE BYTE
	PI	TTYI	;GET A CHARACTER
	NI	$7F	;TURN PARITY OFF
	CI	$7F	;RUBOUT?
	BZ	GET3	;B IF YES
	CI	$08	;BACKSPACE?
	BNZ	GET4	;B IF NOT
			;BACKUP DC0 TO DELETE A CHAR
GET3	LI	<-1	;BACKUP
	ADC		;DC0
	LR	A,8	;ADJUST
	INC		;THE
	LR	8,A	;COUNTER
	LI	$08	;SET BACKSPACE
;	LR	H,DC	;ECHO
;	LM		;THE LAST
;	LR	DC,H	;CHARACTER
	BR	GET2	;DONT STORE
GET4	CI	$7D	;DELETE LINE ?
	BNZ	GET5	;B IF NOT ALT-MODE
	PI	TTCR	;OUTPUT CR LF
	LI	$5E	;AND UP ARROW (163)
	BR	GET1	;AND START OVER	(164)
GET5	CI	$0A	;LR ?
	BZ	GET2	;IGNORE IT
	CI	0	;NULL ?
	BZ	GET2	;IGNORE IT
	ST		;STORE IN BUFF
	DS	8	;CHECK BUFF ROOM
	BZ	GET3	;B IF NO MORE ROOM
	CI	$0D	;CR ?
	BNZ	GET2	;B IF NOT CR
	PI	TTCR	;OUTPUT CR LF
	JMP	PULLRT	;RETURN
			;
			;IF TXTU=PRESENT DC THEN STOP LOOKING
			;THIS ROUTING LOOKS FOR A LINE NUMBER
			;THE LINE NUMBER IS IN SCRATCH 20-21
			;CC=0 FOUND LINE, CC=+ PAST A NUMBER,
			;CC=- PAST END OF TEXT
			;FOR A FNDL ENTRY DC POINTS TO LINE NUMBER
FNDLN	DCI	TXTB	;LOAD BEGIN OF TEXT ADDR
FNDL	LR	K,P	;SAVE RETURN
FND1	LISL	6	;SET ISAR TO TXTU
	PI	PUSHDC	;PUT PRESENT TBP ON THE STACK
	PI	COMT	;ADDR-TXTU SKIP LR H,DC AND LISL 0
	BNC	FND2	;B IF NOT THE END
	CLR		;SET
	LR	9,A	;STATUS
	LR	W,J	;TO NO CARRY
FNDR	PK		;RETURN
FND2	LISL	4	;PUT THE
	LM		;TEXT
	LR	I,A	;NUMBER
	LM		;ON
	LR	D,A	;THE
	PI	PUSHSR+1	;STACK
	PI	COMX	;TEXT-INPUT
	BC	FNDR	;B IF PAST OR EQUAL
	LM		;GET PAST
	LM		;LINE NUMBER
	BR	FND4	;LOOK FOR NEXT LINE
			;DC MUST BE SET PAST LINE # FOR THIS ENTR
FNDNXT	LR	K,P	;SAVE RETURN
FND4	LM		;LOAD NEXT CHAR
	CI	$0D	;CR ?
	BNZ	FND4	;B IF NOT
	BR	FND1	;KEEP LOOKING
			;
			;DC POINTS TO LINE TO PRINT
PRTLN	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	LISL	0	;SET ISAR
	LM		;LOAD
	LR	I,A	;THE
	LM		;NUMBER
	LR	I,A	;INTO 20-21
	LIS	4	;SET NUMBER
	LR	3,A	;OF CHARS TO PRINT
	PI	PRTNUM	;CONVERT AND PRINT
	PI	PBLK	;PRINT A BLANK
	CLR		;SET END CHAR
	LR	8,A	;TO ZERO
	PI	PRTSTG	;PRINT A STRING
	JMP	PULLRT	;RETURN
			;
			;PRINT UNTIL MATCH OF R3
			;OR A CR IS FOUND
PRTSTG	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
PRT1	LM		;LOAD A CHAR
	LR	4,A	;SAVE CHAR
	LR	1,A	;OUTPUT REG
	XS	8	;SEE IF A MATCH
	BZ	PRT2	;RETURN IF A MATCH
	PI	TTY0	;OUTPUT A CHAR
	LR	A,4	;DID WE OUTPUT
	CI	$0D	;A CR ?
	BNZ	PRT1	;B IF NOT
PRT2	JMP	PULLRT	;RETURN
			;
			;PRINT NUMBER IN R20-21
PRTNUM	LR	K,P	;SAVE RETURN
	PI	PUSHRT	;ADDR ON THE STACK
			;ROUTINE TO CONVERT HEX TO DECIMAL
			;HEX NUMBER MUST BE IN SCRATCH 20-21
			;CHANGES SCRATCH 22-23 AND 24-25
	PI	CHKSGN	;CHECK SIGN
	LISL	2	;SET SCRATCH (250)
	CLR		;22-23 (251)
	LR	I,A	;TO
	LIS	10	;DECIMAL
	LR	D,A	;10
	PI	PUSHSR	;PUT A 10 ON THE STACK
	LR	A,3	;SAVE
	LR	4,A	;FORMAT #
XCV1	PI	DIVIDE	;DIVIDE BY 10
	PI	PUSH20	;SAVE DIGIT(REMAINDER)
	LISL	4	;MOVE THE
	PI	PUSHSR	;RESULT
	PI	PULL20	;TO 20-21
	DS	4	;DEC DIGIT COUNTER
	LR	A,I	;SEE IF
	XS	S	;EXCLUSIVE OR AND
	AS	D	;ADD TO CHECK FOR ZERO
	BNZ	XCV1	;B IF MORE
XCV2	DS	4	;NEED TO PAD BLANKS ?
	BM	XCV3	;B IF WE DONT
	PI	PBLK	;PRINT A BLANK
	BR	XCV2	;SEE IF WE NEED MORE BLANKS
XCV3	LR	A,8	;OUTPUT
	BR	XCV5	;THE SIGN
XCV4	PI	PULLSR	;GET A DIGIT
	CI	10	;LAST ONE ?
	BZ	XCV6	;B IF LAST
	OI	$30	;ASCII
XCV5	LR	1,A	;OUTPUT REG
	PI	TTY0	;OUTPUT
	BR	XCV4	;ANOTHER
XCV6	JMP	PULLRT	;RETURN
			;
			;OUTPUT A BLANK
PBLK	LI	' 	;LOAD A BLANK
	LR	1,A	;OUTPUT REG
	JMP	TTY0	;GO PRINT
			;
			;CHECK FOR ' OR " TYPE STRING
			;R8 HAS THE PRESENT BYTE
			;CC=0 FOR A DROP THRU RETURN
QSTRING	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	LR	A,4	;GET CHAR
	CI	''	;STRING ?
	BNZ	QST4	;NOT ' MAYBE "
QST1	LR	8,A	;LOAD END CHAR
	LM		;GET PAST IT
	PI	PRTSTG	;PRINT STRING
QST2	PI	POPRT	;PULL RETURN INTO 12-13
	LR	A,4	;WAS THE LAST A CR
	CI	$0D	;CR ?
	BNZ	QST3	;B IF NOT CR
	JMP	RNXL	;RUN NEXT LINE
QST3	PI	CHAR	;GET NEXT CHAR
	XS	4	;SET CC=0 FOR DROP THRU RETURN
	PK		;RETURN
QST4	CI	'"	;STRING ?
	BZ	QST1	;GO LOAD END CHAR
QST5	CI	$5F	;A BACK ARROW
	BNZ	QST6	;B IF NOT
	LIS	13	;OUTPUT JUST A CR
	LR	1,A	;OUTPUT REG
	PI	TTY1	;OUTPUT THE CR
	LM		;GET PAST <
	BR	QST2	;GO DROP THRU RETURN
QST6	JMP	PULLRT	;RETURN AND BRANCH
			;
			;SEE IF VARIABLE OR ARRAY
			;IF SO PUT ADDR IN DC1, TBP IN DC0
TESTVL	LR	A,4	;LOAD CHARACTER
	AI	$C0	;SUBTRACT @
	BM	TVR	;B IF NOT A VARIABLE
	LR	J,W	;SAVE STATUS
	LR	2,A	;SAVE VARIABLE
	CI	26	;A-Z ?
	BM	TVR	;B IF NOT
	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	PI	SKIP	;INC DC AND GET NEXT CHAR
	CI	'$	;A STRING ?
	BNZ	TVS	;B NOT A STRING
	LR	A,9	;SAVE STATUS
	LR	5,A	;SET AS STRING
	PI	SKIP	;GET NEXT CHARACTER
TVS	LR	W,J	;RESTORE STATUS
	BNZ	TV1	;B IF A VARIABLE
	PI	PARN	;( SHOULD BE NEXT (337)
	PI	MV2021	;MOVE 20-21 TO 22-23 (338)
	PI	ADDD	;DOUBLE INDEX
	BP	TVT	;B IF NOT TOO BIG
			;MAY BE @(-INDEX)
	LR	A,5	;CHANGE STATUS
	COM		;OF THE
	INC		;PREVIOUS
	LR	5,A	;STRING JUST IN CASE
	LR	A,I	;SEE IF
	INC		;LT -255
	BNZ	TVE	;B IF NOT
	LR	A,D	;MAKE
	COM		;LOW
	INC		;POSITIVE
	CI	52	;@(-INDEX) PAST Z ?
	BP	TV2	;B IF IT ISNT
TVE	JMP	QHOW	;ERROR
TVT	XDC		;SAVE TBP
	DCI	VARBGN	;BEGIN OF ARRAY
	LR	H,DC	;INTO 10-11
	PI	MV2021	;MOVE 2*INDEX INTO R22-23
	LR	A,10	;SO WE
	LR	I,A	;CAN
	LR	A,11	;PUT BEGIN
	LR	D,A	;IN 20-21
	PI	SUBD	;VARBGN-INDEX
	LISL	6	;PUT TXTU
	PI	PUSHSR	;ON THE STACK
	PI	COMP	;TXTU-@(INDEX)
	BNC	TVD	;B IF ROOM LEFT
	XDC		;GET TBP
QSORRY	PI	PUSHDC	;SAVE TBP
ASORRY	DCI	SORRY
	JMP	ERROR	;PROCESS ERROR
TVD	SR	1	;MAKE STATUS + CR 0
	PI	PUSHSR	;MOVE VAR ADDR
	PI	PULLDC	;TO DC
	BR	TV3	;GO RETURN
			;A-Z VARIABLE
TV1	LR	A,2	;LOAD VARIABLE
	SL	1	;VAR INDEX*2
TV2	XDC		;SAVE TBP
	DCI	VARBGN	;GET
	ADC		;VARIABLE ADDR
TV3	XDC		;DC0=TBP, DC1=VAR ADDR
	JMP	PULLRT
TVR	POP		;FAST RETURN
			;
			;TEST AN ITEM POINTED TO BY DC
			;THE NUMBER AND (20-21) WILL CONTAIN
			;THE HEX CONVERSION OF IT
			;IF R1=0 NOT A NUMBER
TSTNUM	LR	K,P	;SAVE RETURN
	LISL	0	;SET ISAR
	CLR		;ZERO
	LR	I,A	;LEAD
	LR	D,A	;BYTES
	INC		;SET R=1 FOR NO NUMBER
	LR	1,A	;AND DIGIT COUNTER
TS1	PI	CHAR	;GET NEXT CHAR
	CI	$2F	;SEE
	BP	TS2	;IF
	CI	$39	;A
	BP	TS3	;DECIMAL
TS2	PK		;RETURN
TS3	SL	4	;STRIP
	SR	4	;ASCII
	LR	2,A	;SAVE THE DIGIT
	DS	1	;SET R1 FOR A NUMBER FOUND
	PI	MV2021	;MOVE 20-21 TO 22-23
	CLR		;ZERO R20
	LR	I,A	;AND
	LR	S,A	;R21
	LIS	10	;MULTIPLY
	LR	7,A	;EXISTING DIGITS
	PI	MULT	;BY 10
	LISL	1	;NOW
	LR	A,S	;ADD
	AS	2	;THE
	LR	D,A	;NEW
	LR	A,S	;DIGIT
	LNK		;TO THE
	LR	S,A	;ACCUMULATED RESULT
	LM		;SKIP THIS BYTE
	BP	TS1	;B IF NO OVERFLOW
QHOW	PI	PUSHDC	;SAVE TBP
AHOW	DCI	HOW
	JMP	ERROR	;(425)
			;DC1 MUST POINT TO TABLE (426)
			;DC0 POINTS TO WORD
			;REG H POINTS TO DC0
DIRECT	DCI	TAB1	;COMMAND TABLE
EXEC	XDC		;IN DC1
	LR	DC,H	;DC0=TINY BASIC POINTER(TBP)
	LI	<-1	;SET R1
	LR	1,A	;TO -1
EX1	LM		;LOAD FROM TB LINE
	XDC		;GET TABLE ADDR
	CI	'.	;PERIOD ?
	BZ	EX3	;B IF YES
	CM		;COMPARE
	XDC		;PUT TBP BACK IN DC0
	BZ	EX1	;B IF A MATCH
			;HERE NO MATCH
	LR	A,1	;BACKUP
	ADC		;TBP
	XDC		;AND GET THE
	ADC		;LAST ACCESSED
	LM		;TABLE BYTE
	NS	1	;AN ADDR ?
	BM	EX4	;B IF IT WAS
			;LOOK FOR ADDR
EX2	LM		;LOAD
	NS	1	;AN ADDR?
	BP	EX2	;B IF NOT
	LM		;GET LOW BYTE
	BR	EXEC	;RESTORE WORD ADDR
			;FOUND A PERIOD
EX3	LM		;LOAD NEXT CHAR
	NS	1	;AN ADDR?
	BP	EX3	;B IF NOT
EX4	SL	1	;TURN SIGN
	SR	1	;BIT OFF
	LR	KU,A	;SAVE HI ORDER
	LM		;LOAD
	LR	KL,A	;LOW ORDER
	XDC		;GET TB POINTER IN DC0
	PK		;CALL ROUTINE
			;
			;SKINP IN 32-33
INPERR	LISL	2	;SETUP SKINP ISAR
	LR	A,I	;RESTORE
	LR	QU,A	;THE
	LR	A,D	;OLD
	LR	QL,A	;STACK
	PI	PULL20	;RESTORE CURRNT
	LISU	2	;RESET ISAR
	PI	PULLDC	;CLEAR STACK
	PI	PULLDC	;GET ORIGINAL TBP
			;
INPUT	PI	PUSHDC	;SAVE TBP IN CASE OF ERROR
IP1	PI	CHAR	;GET NEXT CHAR
	PI	QSTRING	;SEE IF A STRING
	BNZ	IP2	;B NOT A STRING
	PI	TESTVL	;VARIABLE ?
	BM	IP4	;B IF NOT
	BR	IP3	;B IF A VARIABLE
			;HERE NOT A STRING
IP2	PI	PUSHDC	;SAVE TBP FOR PRTSTG
	PI	TESTVL	;VARIABLE ?
	BP	*+5	;B IF A CAR
	JMP	QWHAT	;ERROR
	LR	H,DC	;SAVE TBP
	LM		;SAVE
	LR	7,A	;THIS BYTE
	CLR		;AND
	LR	DC,H	;STORE
	ST		;A ZERO
	LR	8,A	;FOR END OF STRING
	PI	PULLDC	;GET TBP
	PI	PRTSTG	;PRINT STRING
	LI	<-1	;BACKUP
	ADC		;DC
	LR	H,DC	;SAVE TBP
	LR	A,7	;AND RESTORE
	ST		;CHAR
	LR	DC,H	;RESTORE TBP
			;HERE AN INPUT VARIABLE
IP3	PI	PUSHDC	;SAVE TBP
	LISU	3	;SAVE
	PI	PUSH20	;CURRNT
	LI	<-1	;SET CURRNT
	LR	S,A	;TO MINUS
	LISL	2	;ISAR FOR SKINP
	LR	A,QU	;SAVE
	LR	I,A	;THE (513)
	LR	A,QL	;STACK (514)
	LR	I,A	;POINTER
	LISU	2	;RESET ISAR
	XDC		;SAVE
	PI	PUSHDC	;VARIABLE ADDR
			;PROMPT FOR INPUT
	LI	':	;PROMPT
	LR	1,A	;CHAR
	PI	GETLN	;GET A LINE
	DCI	BUFF	;INPUT ADDR
	LR	A,5	;SETUP
	LR	9,A	;STRING
	LR	W,J	;STATUS
	BM	IPX	;B IF NOT A STRING
	PI	PULLDC	;GET VAR ADDR
	PI	BUFTOV	;MOVE BUF TO VAR
	BR	IPS	;CONTINUE
IPX	PI	EXPR	;EVALUATE EXPR
	PI	PULLDC	;GET VAR ADDR
	LR	A,I	;STORE THE VALUE
	ST		;INTO
	LR	A,D	;THE
	ST		;VARIABLE
IPS	LISU	3	;RESTORE
	PI	PULLSR	;CURRNT
	LISU	2	;RESTORE
	PI	PULLDC	;TBP
IP4	PI	POPRT	;CLEAR STACK
	PI	IGNBK	;GET NEXT CHAR
	CI	',	;COMMA ?
	BZ	INPUT	;B IF MORE
			;SEE IF PROPER END
FINI	LI	<-1	;BACKUP
	ADC		;TBP
FIN	PI	FINISH	;FINISH
	JMP	QWHAT	;RETURN HERE IS AN ERROR
			;
			;HERE IF NO LET
DEFLT	PI	IGNBK	;GET NEXT CHAR
	CI	$0D	;AN EMPTY LINE
	BNZ	*+5	;B NOT EMPTY
	JMP	RNXL	;ITS OK GET NEXT LINE
	LR	DC,H	;RESTORE TBP
			;
LET	PI	SETVAL	;GET VARIABLE
	LR	A,4	;RESTORE CHAR
	CI	',	;COMMA ?
	LM		;GET PAST THIS CHAR
	BZ	LET	;DO IT AGAIN
	BR	FINI	;FINISH UP
			;
			;PRINT A STRING OR NUMBER
			;R3 IS THE FORMAT NUMBER
PRINT	LIS	6	;SET
	LR	3,A	;DIGIT COUNTER
	PI	IGNBK	;GET NEXT CHAR
	CI	';	;MULTIPLE RECOR ?
	BNZ	PR1	;B IF NOT
	PI	TTCR	;JUST A CR LF
	JMP	RSML	;RUN SAME LINE
PR1	CI	$0D	;CR ?
	BNZ	PR2	;B NOT CR
	PI	TTCR	;JUST CR LF
	JMP	RNXL	;RUN NEXT LINE
PR2	CI	'#	;FORMAT CHANGE ?
	BNZ	PR3	;B IF NOT
	PI	EXPR	;EVALUATE FORMAT
	LISL	1	;GET FORMAT OUT
	LR	A,I	;OF 20-21
	LR	3,A	;INTO R3
	DS	3	;ADJUST FORMAT
	BR	PR4	;CHECK FOR COMMA
PR3	LI	<-1	;BACKUP
	ADC		;TBP
	PI	QSTRING	;SEE IF A STRING
	BNZ	PR6	;B IF NOT A STRING
			;DROPS THRU IF STRING OR BACK
PR4	LR	A,4	;LOAD CHAR
	CI	',	;COMMA ?
	BNZ	PR5	;B IF NOT COMMA
	LM		;GET PAST COMMA
	PI	FINISH	;GO FINISH UP LINE
	BR	PR2	;CONTINUE
PR5	PI	TTCR	;LIST END SO CR LF
	JMP	FIN	;FINISH UP
PR6	PI	EXPR	;EVALUATE EXPRESSION
			;SEE IF A STRING (600)
	LR	A,5	;GET STRING FLAG (601)
	LR	9,A	;INTO
	LR	W,J	;STATUS REG
	BM	PR7	;B IF NOT STRING
	DS	5	;CLEAR STRING FLAG
	XDC		;SAVE TBP
	DCI	BUFF	;ADDR OF STRING
	CLR		;GET STRING
	LR	8,A	;TERMINATOR
	PI	PRTSTG	;GO PRINT STRING
	XDC		;RESTORE TBP
	BR	PR8	;CONTINUE
PR7	PI	PRTNUM	;PRINT THE NUMBER
PR8	PI	CHAR	;GET NEXT CHAR
	BR	PR4	;LOOK FOR COMMA
			;
GOSUB	PI	SAVE	;SAVE FOR PARAMETERS
	PI	EXPR	;EVALUATE EXPR
	PI	PUSHDC	;SAVE TBP
	PI	FNDLN	;FIND TARGET LINE
	BZ	GOS1	;B IF FOUND
	JMP	AHOW	;ERROR
GOS1	LISU	3	;SET
	PI	PUSH20	;SAVE CURRNT
	LISL	4	;SAVE
	PI	PUSHSR	;SKGOS
	LR	A,QU	;PUT STACK
	LR	I,A	;POINTER
	LR	A,QL	;INTO
	LR	I,A	;SKGOS
	CLR		;ZERO
	LR	I,A	;LOPVAR
	LR	I,A	;IN SCRATCH
	JMP	RTSL	;RUN THE LINE
			;
RETURN	PI	ENDCR	;LOOK FOR CR
	LISU	3	;SET ISAR
	LISL	4	;TO SKGOS
	LR	A,I	;LOAD HI
	XS	S	;EXCLUSIVE OR AND
	AS	D	;AND ADD TO CHECK FOR 0
	BNZ	RET1	;B IF NOT
	JMP	QWHAT	;DIDNT EXIST
RET1	LR	A,I	;LOAD	
	LR	QU,A	;STACK POINTER
	LR	A,D	;FROM
	LR	QL,A	;SKGOS
	PI	PULLSR	;LOAD OLD SKGOS
	PI	PULL20	;LOAD CURRNT
	PI	PULLDC	;RESTORE TBP
	XDC		;SAVE DC
	PI	RESTOR	;GO RESTORE
	XDC		;RESTORE TBP
	PI	FIN	;FINISH UP
WHAT	DC	"WHAT"
	DC	$0D
HOW	DC	"HOW"
	DC	$0D
			;3E6-3FF USED BY FAIRBUG
SORRY	DC	"SORRY"
			;
	DC	$0D
	DC	" FAIRBUG USES"
			;
			;
			;
	DC	"3E6-3FF"
			;
	DC	"9ABCDEF"
			;
			;
			;LIST (CR) LISTS ALL SAVED LINES
			;LIST N (CR) FROM N DOWN
			;LIST N,# (CR) WILL LIST 
			;# LINES FROM N DOWN
LIST	PI	TSTNUM	;SEE IF A NUMBER
	DS	1	;WAS IT?
	BZ	LIS4	;B IF IT WAS NOT
	LR	A,4	;SEE IF THE
	CI	',	;NEXT ONE IS A COMMA
	BNZ	LIS4	;B IF IT ISNT
	PI	PUSHSR	;SAVE THE LINE #
	PI	SKIP	;GET THE NEXT CHAR
	PI	TSTNUM	;AND THE NEXT NUMBER
	DS	1	;WAS IT A NUMBER
	BNZ	LIS1	;B IF IT WAS
	JMP	QWHAT	;ELSE ERROR (687)
LIS1	LR	A,S	;IS THE (688)
	AS	I	;NUM OF LINES GT 255
	BZ	LIS3	;B IF IT ISNT
LIS2	JMP	QHOW	;ELSE ERROR
LIS3	LR	A,S	;LOAD THE
	LR	6,A	;NUMBER OF LINES TO PRINT
	AS	D	;SEE IF ZERO
	BZ	LIS2	;ERROR IF IT IS
	PI	PULLSR	;RESTORE BEGIN LINE #
	LIS	1	;SET LIST FLAG FOR N,#
	BR	LIS5	;TO LIST #,n
LIS4	CLR		;SET LIST FLAG
LIS5	LR	5,A	;TO NO N
	PI	ENDCR	;GET PAST CR
	PI	FNDLN	;FIND A LINE
	BNC	LIS7	;B IF PAST TXTU
LIS6	PI	PRTLN	;PRINT A LINE
	PI	FNDL	;GET NEXT LINE
	BNC	LIS7	;B IF PAST TXTU
	LR	A,5	;SEE IF LOOPING
	AS	5	;ON N
	BZ	LIS6	;B IF NOT
	DS	6	;DEC N
	BNZ	LIS6	;AND LOOP
LIS7	JMP	START	;GO PROMPT
			;
			;CLEAR TEXT AREA
NEW	PI	ENDCR	;CLEAR TEXT LINE
NEWT	DCI	TXTB	;BEGIN ADDR
	LR	H,DC	;IN 10-11
	LISU	2	;SET ISAR FOR INITIAL ENTRY
	LISL	6	;SET ISAR TO TXTU
	LR	A,10	;RESET
	LR	I,A	;TO
	LR	A,11	;THE BEGINNING
	LR	D,A	;OF TEXT AREA
	JMP	START	;RESTART
			;
STOP	PI	ENDCR	;FIND CR
	JMP	START	;RESTART
			;
			;IF TRUE RUN SAME LINE
			;IF NOT TRUE RUN NEXT LINE
IF	PI	EXPR	;EVALUATE THE EXPRESSION
	LR	A,I	;SEE IF
	XS	S	;EXCLUSIVE OR AND
	AS	D	;ADD TO CHECK FOR ZERO
	BZ	REM	;B IF IT IS
	JMP	RSML	;RUN SAME LINE
			;REMARK IS A FALSE IF
REM	PI	FNDNXT	;FIND THE NEXT LINE
	BNC	IF1	;B PAST THE END
	JMP	RTSL	;RUN NEXT LINE
IF1	JMP	START	;NO MORE TEXT
			;
			;FOR VAR=EXPR TO EXPR SKIP EXPR
FOR	PI	SAVE	;SAVE FOR VARIABLE
	PI	SETVAL	;GET VARIABLE
	LI	<-2	;BACKUP
	XDC		;DC1
	ADC		;TO GET VAR ADDR
	PI	PUSHDC	;ON THE STACK
	XDC		;RESTORE TBP
	LISU	3	;PUT VARIABLE
	LISL	6	;ADDR INTO
	PI	PULLSR	;LOPVAR
	LISU	2	;RESET ISAR
	DCI	TAB5	;GO LOOK
	JMP	EXEC	;FOR 'TO'
FR1	PI	EXPR	;EVALUATE LIMIT
	PI	PUSH20	;LOPLMT(46-47) ON STACK
	DCI	TAB6	;GO LOOK
	JMP	EXEC	;FOR 'STEP'
FR2	PI	EXPR	;EVALUATE INCREMENT
	BR	FR4	;B AROUND DEFAULT OF 1
FR3	CLR		;NO 'SKIP', SET
	LR	I,A	;INCREMENT
	INC		;TO
	LR	D,A	;ONE
FR4	PI	PUSH20	;LOPINC(44-45)
	LISU	3	;USE CURRNT
	PI	PUSH20	;AS LOPLN(42-43)
	PI	PUSHDC	;AND TBP AS LOPPT(40-41)
	LR	DC,Q	;STACK ADDR IN DC
	PI	REFOR	;PUT THEM ALL IN SCRATCH
	LISU	3	;SET ISAR FOR LOPVAR
	LR	DC,Q	;SAVE (774)
	XDC		;ORIGINAL STACK ADDR (775)
	LR	DC,Q	;RESET DC0
FR5	LR	H,DC	;TEMP SAVE
	LR	Q,DC	;NEW STACK ADDR
	LM		;SEE IF
	OM		;THE END
	BNZ	FR6	;B IF NOT
	XDC		;RESTORE ORIGINAL
	BR	FR8	;STACK ADDR
FR6	LISL	6	;SET ISAR FOR LOPVAR
	PI	COMT	;COMPARE TO LCPVAR
	LIS	10	;GO DOWN TO
	ADC		;THE NEXT LEVEL
	BNZ	FR5	;B IF FOUND
	LI	<-1	;GET
	ADC		;FROM ADDR
	XDC		;RESTORE ORIGINAL STACK ADDR
	LR	Q,DC	;PUT
	PI	PUSHDC	;ON THE STACK TOP
	XDC		;PUT
	LR	H,DC	;FROM
	XDC		;IN BOTH
	LR	DC,H	;DC0 AND DC1
	LIS	10	;TO ADDR IS
	ADC		;FROM+10
	XDC		;IN DC1
	PI	MVDOWN	;MOVE THE STACK DOWN 10 BYTES WORTH
	LR	DC,H	;RESTORE
FR8	LR	Q,DC	;STACK ADDR
	LISU	4	;RESTORE
	PI	PUSH20	;TBP BY USING
	PI	PULLDC	;LOPPT
	LISU	2	;RESET ISAR
	JMP	FIN	;FINISH UP
			;
			;NEXT VAR
NEXT	PI	CHAR	;GET NEXT CHAR
	PI	TESTVL	;TEST VARIABLE
	XDC		;CAR ADDR IN DC0
	BP	*+6	;B AROUND ERROR JUMP
NX0	XDC		;RESTORE TBP
	JMP	QWHAT	;ERROR
	PI	PUSHDC	;PUT VAR ADDR(LOPVAR)
	PI	PULL20	;INTO 20-21
NX1	LISU	3	;SET ISAR
	LISL	6	;TO LOPVAR
	LR	A,I	;SEE
	AS	S	;IF
	XS	D	;ITS ZERO
	BZ	NX0	;B IF ZERO AN ERROR
	PI	PUSHSR	;PUT LOPVAR
	LISU	2	;ON THE STACK TOP
	PI	COMP	;COMPARE NEXT VARIABLE
	BZ	NX2	;TO LOPVAR & b IF EQ
	PI	RESTOR	;RESTORE NEXT LEVEL
	BR	NX1	;KEEP LOOKIN
			;NEED TO ADD LOPINC TO THE
			;VARIABLE LOPVAR POINTS TO.
NX2	PI	SAVE+1	;PUT EVERYTHING BACK SKIP XDC
	XDC		;SAVE TBP
	PI	PUSH20	;GET ADDR OF
	PI	PULLDC	;LOPVAR IN DC
	LR	H,DC	;SAVE LOPVAR ADDR
	LM		;PUT
	LR	I,A	;VALUE
	LM		;OF LOPVAR
	LR	I,A	;IN 20-21
	LR	DC,Q	;SAVE
	LIS	6	;SETUP
	ADC		;TEMP STACK
	LR	Q,DC	;TO GET LOPINC(44-45)
	PI	PULLSR+1	;INTO 22-23 (SKIP LR H,DC)
	PI	ADDD	;INDEX=INDEX+LOPINC
	LR	A,I	;STORE
	ST		;THE
	LR	A,D	;INCREMENTED
	ST		;LOPVAR
	PI	COMX	;COMPARE(LIMIT-INDEX)
	LR	DC,Q	;SAVE THE
	LR	H,DC	;ORIGINAL STACK ADDR
	BZ	NX4	;B IF NOT DONE
			;HERE ASSUMING LOPINC IS +, IT COULD
			;BE - SO BOTH GT AND LT MUST BE CHECKED
			;BACKUP TEMP Q BY 4 BYTES TO LOPINC
	LI	<-4	;RESET TEMP STACK
	ADC		;TO LOPINC
	CLR		;SEE (861)
	OM		;IF MINUS (862)
	BM	NX3	;B IF NEGATIVE INC
	LR	W,J	;RESTORE STATUS
	BM	NX5	;+ INC, BR IF DONE(-)
	BR	NX4	;NOT DONE
NX3	LR	W,J	;RESTORE STATUS
	BP	NX5	;- INC, BR IF DONE(+)
			;STILL LOOPING, SET CURRNT=LOPVAR
			;AND DC0=LOPPT THE NEW TBP-
NX4	LR	DC,Q	;RESET
	LI	<-8	;STACK
	ADC		;TO POINT
	LR	Q,DC	;TO LOPPT(40-41)
	LR	DC,H	;SAVE
	XDC		;ORIGINAL STACK IN DC1
	PI	PULLDC	;GET TBP=LOPPT
	LISU	3	;SET
	PI	PULL20	;CURRNT=LOPLN
	LISU	2	;RESET ISAR
	XDC		;RESET
	LR	Q,DC	;STACK POINTER
	BR	NX6	;GO FINISH LINE
NX5	LR	DC,H	;RESET ORIGINAL
	LR	Q,DC	;STACK
	PI	RESTOR	;GET NEXT FOR-NEXT LEVEL
NX6	XDC		;RESTORE TBP
	JMP	FIN	;FINISH UP
			;
			;READ A,B$,@(I),@$(I)
READ	PI	CHAR	;GET NEXT CHAR
	PI	TESTVL	;A VARIABLE ?
	PI PUSHDC	;SAVE TBP
	BP	*+5
REA1	JMP	AWHAT	;ERROR
	LISU	5	;SET ISAR
	LISL	2	;TO TEMP POINTER
	LR	A,I	;GET PRESENT
	LR	10,A	;DATA
	LR	A,D	;ADDR
	LR	11,A	;INTO
	LR	DC,H	;DC0
	LISU	2	;RESET ISAR
	PI	RDATA	;PROCESS DATA ITEM
	PI	CHAR	;GET NEXT CHAR
	CI	',	;SEE IF A COMMA
	BZ	REA2	;B IF IT IS
	CI	$0D	;CR ?
	BNZ	REA1	;ERROR IF NOT
REA2	PI	SKIP	;GET PAST , OR CR
	LISU	5	;SETUP
	LISL	2	;TEMP POINTER
	LR	H,DC	;STORE
	LR	A,10	;THE
	LR	I,A	;PRESENT
	LR	A,11	;DATA
	LR	D,A	;POINTER
	LISU	2	;RESET ISAR
	PI	PULLDC	;RESTORE TBP
	PI	IGNBK	;WAS LAST CHAR
	CI	',	;A COMMA ?
	BZ	READ	;B IF MORE
	JMP	FINI	;FINISH UP
			;
			;
			;DATA N,'STRING',EXPR
DATA	LR	H,DC	;SAVE TBP
	LISU	5	;SAVE TBP
	LISL	0	;TO DATA POINTER
	LR	A,I	;SEE IF
	XS	S	;ZERO BY
	AS	D	;XOR AND ADDING
	BNZ	DAT1	;B IF NOT ZERO
	LR	A,10	;SETUP
	LR	I,A	;PERMANENT
	LR	A,11	;DAT
	LR	I,A	;POINTER
	LR	A,10	;AND THE
	LR	I,A	;TEMP
	LR	A,11	;POINTER
	LR	I,A	;AS WELL
DAT1	LISU	2	;RESET ISAR
	LR	DC,H	;RESTORE TBP
	JMP	REM	;RUN THE NEXT LINE
			;
			;RESET DATA POINTER
RESTORE	LISU	5	;SET ISAR
	PI	MV2021	;RESET THE POINTER (948)
	LISU	2	;RESET ISAR (949)
	JMP	FIN	;FINISH UP
			;
			;FIND THE LINE NUMBER AND GOTO I
GOTO	PI	EXPR	;EVALUATE THE EXPRESSION
	PI	PUSHDC	;SAVE DC IN CASE OF ERROR
	PI	ENDCR	;FIND CR
	PI	FNDLN	;FIND THE LINE
	BNZ	GO1	;B IF NOT FOUND
	PI	POPRT	;CLEAR THE STACK
	BR	RTSL	;RUN THE LINE
GO1	JMP	AHOW	;PROCESS ERROR
			;
RUN	PI	ENDCR	;FIND CR
	DCI	TXTB	;BEGIN OF TEXT ADDR
			;RUN THE NEXT LINE
RNXL	LISL	0	;SET SCRATCH
	CLR		;20-21
	LR	I,A	;THE LINE NUMBER
	LR	D,A	;TO ZERO
	PI	FNDL	;FIND NEXT LINE
	BC	RTSL	;B IF NOT PAST TXTU
	JMP	START	;RESTART
			;SAVE CURRENT LINE ADDR
RTSL	LISU	3	;GET
	LISL	0	;VALE OF
	LR	A,10	;CURRNT
	LR	I,A	;STORE
	LR	A,11	;NEW
	LR	D,A	;LINE NUMBER
	LISU	2	;RESET ISAR
	LR	DC,H	;GET PAST
	LM		;LINE NUMBER
	LM		;LINE NUMBER
			;RUN THE SAME LINE
RSML	LR	H,DC	;PUT LINE ADDR IN H
	CLR		;CLEAR
	LR	5,A	;STRING FLAG
	DCI	TAB2	;TB COMMANDS TABLE
	JMP	EXEC	;GO PROCESS
			;
			;FINISH UP THE LINE
FINISH	LR	K,P	;SAVE RETURN
	PI	IGNBK	;GET NEXT CHAR
	CI	';	;MULTIPLE STATEMENT ?
	BZ	RSML	;YES RUN SAME LINE
	CI	$0D	;CR ?
	BZ	RNXL	;YES RUN NEXT LINE
	PK		;RETURN
			;
			;EVALUATE AN EXPRESSION
EXPR	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	PI	EXPR2	;GET 1ST EXPRESSION
	PI	PUSH20	;SAVE 1ST EXPR
EXPR1	LR	H,DC	;SAVE TBP
	DCI	TAB8	;RELATIONAL OPERATOR TABLE
	JMP	EXEC	;GO SEE IF WE HAVE OP
			;
XP11	PI	XP18	;">="
	BC	TRUE	;B TRUE
	BR	FALSE	;SET FALSE=0
XP12	PI	XP18	;"#"
	BNZ	TRUE	;B TRUE
	BR	FALSE	;SET FALSE=0
XP13	PI	XP18	;">"
	BZ	FALSE	;SET FALSE=0
	BC	TRUE	;B TRUE
	BR	FALSE	;SET FALSE=0
XP14	PI	XP18	;"<="
	BNC	TRUE	;B TRUE
	BZ	TRUE	;B TRUE
	BR	FALSE	;SET FALSE=0
XP15	PI	XP18	;"="
	BZ	TRUE	;B TRUE
	BR	FALSE	;SET FALSE=0
XP16	PI	XP18	;"<"
	BNC	TRUE	;B TRUE
FALSE	DS	D	;SET R21=0
TRUE	JMP	PULLRT	;RETURN
			;NOT A RELATIONAL OPERATOR
XP17	PI	PULLSR	;GET 1ST EXPRESSION
	JMP	PULLRT	;RETURN
			;GET 2ND EXPR AND COMPARE
XP18	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	CLR		;CLEAR (1035)
	LR	5,A	;STRING FLAG(1036)
	PI	EXPR2	;GET 2ND EXPR
	PI	POPRT	;POP RETURN INTO K
			;IF THE 2 ITEMS HAVE THE SAME SIGN
			;LEAVE AS IS, BUT IF THE SIGN IS
			;DIFFERENT EXCHANGE THE STACK AND ISAR
	LR	DC,Q	;STACK ADDR
	LR	A,S	;LOAD HI BYTE
	XM		;XOR THEM
	LR	DC,H	;RESTORE TBP
	BP	XP19	;B IF THE SAME SIGN
	PI	MV2021	;MOVE 2ND EXPR TO 22-23
	PI	PULLSR	;STACK(1ST EXPR) INTO 20-21
	LISL	2	;2ND EXPR
	PI	PUSHSR	;ONTO STACK TOP
XP19	PI	COMP	;COMPARE 1ST AND 2ND EXPR
	CLR		;SET
	LR	I,A	;20-21=1
	INC		;FOR
	LR	S,A	;TRUE AND SET LISL 1
	LR	W,J	;RESTORE STATUS
	PK		;RETURN
			;DC MUST CONTAIN TBP
EXPR2	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	LISL	0	;SET ISAR
	PI	CHAR	;GET NEXT CHARACTER
	CI	'-	;MINUS ?
	BNZ	XP21	;B IF NOT
	CLR		;SET
	LR	I,A	;FIRST
	LR	D,A	;EXPR=0
	BR	XP26	;TREAT LIKE SUBTRACT
XP21	CI	'+	;PLUS ?
	BNZ	XP22	;B IF NOT
	PI	SKIP	;INC DC AND GET NEXT CHAR
XP22	PI	EXPR3	;PROCESS FIRST EXP
XP23	LR	A,4	;LOAD THE CHAR
	LISL	0	;RESET TO 20-21
	CI	'+	;ADD ?
	BNZ	XP25	;B IF NOT
	PI	PUSHSR	;SAVE FIRST EXPR
	PI	SKIP	;INC DC AND GET NEXT CHAR
	PI	EXPR3	;PROCESS 2ND EXPR
XP24	LISL	2	;GET 1ST
	PI	PULLSR	;EXPR INTO 22-23
	LR	A,S	;LOAD HI
	LISL	0	;SET TO OTHER HI
	XS	S	;EXCLUSIVE OR
	LR	J,W	;SAVE STATUS OF SIGNS
	PI	ADDD	;ADD
	LR	W,J	;RESTORE STATUS
	BM	XP23	;B IF SIGNS DIFFER
	LR	A,S	;SIGNS THE SAME
	LISL	2	;SO MUST BE RESULT
	XS	S	;EQUAL?
	BP	XP23	;B IF THEY ARE
	JMP	QHOW	;PROCESS ERROR
XP25	CI	'-	;MINUS ?
	BZ	XP26	;B IF MINUS
	JMP	XP45	;RETURN
XP26	PI	PUSHSR	;SAVE FIRST EXPR
	PI	SKIP	;INC DC AND GET NEXT CHAR
	PI	EXPR3	;GET 2ND EXPR
	PI	CHGSGN	;CHANGE SIGN
	BR	XP24	;GO ADD
			;
EXPR3	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	PI	EXPR4	;GET FIRST EXPR
XP30	LR	A,4	;LOAD THE CHAR
XP31	CI	'*	;MULTIPLY ?
	BNZ	XP34	;B IF NOT
	PI	PUSH20	;SAVE 1ST EXPR
	PI	SKIP	;INC DC AND GET NEXT CHAR
	PI	EXPR4	;GET END EXPR
	PI	CHKSGN	;CHECK SIGN
	LR	A,8	;SAVE
	LR	2,A	;THE SIGN
	PI	EXCH	;EXCHANGE STACK AND 20-21
	PI	CHKSGN	;CHECK THE SIGN
	LI	$FF	;SEE IF
	NS	6	;HI GT 255
	BZ	XP32	;B LE 255
			;NUMBER IN 20-21 GT 255
	LI	$FF	;SEE IF
	NS	S	;THIS GT 255 (1122)
	BNZ	XP33	;B IF GT 255(OVERFLOW WILL OCCUR) (1123)
	PI	EXCH	;SWITCH SO SMALL IN R7-8
XP32	PI	MV2021	;MOVE 20-21 TO 22-23
	CLR		;ZERO
	LR	I,A	;20-21
	LR	D,A	;FOR A MULT
	PI	MTPLY	;GO MULTIPLY
	PI	POPRT	;CLEAR STACK
	BP	XP35	;TAKE CARE OF SIGNS
XP33	JMP	QHOW	;PROCESS ERROR
XP34	CI	'/	;DIVIDE ?
	BZ	*+5	;B IF /
	JMP	XP45	;GO RETURN
	PI	PUSH20	;SAVE 1ST EXPR
	PI	SKIP	;INC DC AND GET NEXT CHAR
	PI	EXPR4	;GET 2ND EXPR
	PI	CHKSGN	;CHECK SIGN OF 2ND
	LR	A,8	;SAVE
	LR	2,A	;SIGN
	PI	EXCH	;SWITCH FIRST INTO SCRATCH
	PI	CHKSGN	;CHECK SIGN OF 1ST EXPR
	LISL	2	;PUT 2ND
	PI	PULLSR	;EXPRESSION IN 22-23
	LR	A,I	;SEE IF
	XS	S	;EXCLUSIVE OR AND
	AS	D	;ADD TO CHECK FOR ZERO
	BZ	XP33	;B IF WE ARE
	PI	DIVIDE	;GO DIVIDE
	PI	PUSHSR	;MOVE
	PI	PULL20	;RESULT IN 20-21
			;ADJUST SIGN OF RESULT
XP35	CLR		;SEE IF
	AS	S	;RESULT IS +
	BM	XP33	;B IF IT ISNT
	LR	A,2	;SEE IF
	AS	8	;SIGNS DIFFER
	BZ	XP30	;B IF 2 +'S
	CI	'-	;IS JUST ONE A -
	BNZ	XP30	;B IF 2 -'S
	PI	CHGSGN	;CHANGE THE SIGN
	BR	XP30	;CONTINUE
			;EVALUATE THE INPUT
EXPR4	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	LR	H,DC	;SAVE TBP
	DCI	TAB4	;FUNCTION TABLE
	JMP	EXEC	;GO LOOK
XP40	PI	TESTVL	;TEST THE VALUE
	BM	XP44	;B IF NOT A VAR
			;CHECK FOR A STRING
	LISL	0	;SET ISAR
	LR	A,5	;GET
	LR	9,A	;STRING
	LR	W,J	;FLAG
	BM	XP43	;B IF NOT A STRING
			;PROCESS STRING
	PI	PUSHDC	;SAVE TBP
	DCI	BUFF	;TO ADDR
	XDC		;RESTORE VAR ADDR
	LR	H,DC	;SAVE VAR ADDR
	CLR		;ZERO ACCUM
	LR	W,J	;GET STATUS
	BNZ	*+5	;B IF A-Z
	LM		;ADJUST ARRAY LOC
	LI	<-2	;GET VAR
	LR	1,A	;INTO R1
	LI	72	;SETUP MAX
	LR	2,A	;DIGIT COUNTER
XP41	DS	2	;CHECK LENGTH
	BNZ	*+5	;B IF NOT TOO LONG
	JMP	AHOW	;ERROR
	LM		;LOAD A CHAR
	XDC		;GET BUFF ADDR
	ST		;STORE CHAR
	NI	$80	;LAST CHAR ?
	BNZ	XP42	;B IF LAST
	XDC		;RESET VAR ADDR
	LR	A,1	;ADJUST
	ADC		;VAR ADDR
	BR	XP41	;CONTINUE
XP42	CLR		;MARK END OF STRING
	ST		;OF THE STRING
	PI	SLEN	;STORE LENGTH
	LR	DC,H	;RESTORE
	XDC		;VAR ADDR
	LR	DC,H	;VAR ADDR
	LM		;LOAD (1209)
	LR	I,A	;THE (1210)
	LM		;1ST AND 2ND CHARS
	NI	$7F	;INSURE HIGH
	LR	I,A	;BIT IS OFF
	PI	PULLDC	;RESTORE TBP
	BR	XP45	;GO RETURN
XP43	XDC		;GET VAR ADDR
	LM		;LOAD THE
	LR	I,A	;VALUE OF
	LM		;THE VARIABLE
	LR	D,A	;INTO 20-21 LISL 0
	XDC		;RESTORE TBP
	BR	XP45	;RETURN
XP44	PI	TSTNUM	;SEE IF A NUMBER
	DS	1	;NUMBER ?
	BZ	PAR1	;B IF NOT A NUMBER
XP45	JMP	PULLRT	;RETURN
			;
PARN	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
PAR1	PI	IGNBK	;GET NEXT CHAR
	CI	'(	;LEFT HAND PAREN ?
	BNZ	QWHAT	;B IF NOT
	PI	EXPR	;EVALUATE EXPRESSION
	LR	A,4	;RESTORE CHARACTER
	CI	')	;CLOSING PAREN ?
	BNZ	QWHAT	;B IF NOT FOUND
	PI	SKIP	;INC DC AND GET NEXT CHAR
	JMP	PULLRT	;RETURN
			;
QWHAT	PI	PUSHDC	;SAVE TBP
AWHAT	DCI	WHAT	;WHAT MESSAGE
ERROR	PI	PRTSTG	;PRING WHAT,HOW, OR SORRY
	PI	PULLDC	;GET TBP
	LI	<-1	;GET
	ADC		;POINTER TO CHAR
	LR	H,DC	;IN ERROR
	LM		;SAVE
	LR	5,A	;THE CHAR
	CLR		;PUT
	LR	DC,H	;A ZERO
	ST		;THERE
	LISU	3	;GET CURRNT
	LISL	0	;IN SCRATCH 30
	LR	A,S	;SEE
	AS	S	;IF A MINUS
	BP	*+5	;B IF GE 0
	JMP	INPERR	;REDO INPUT
	LR	A,I	;SEE
	XS	S	;EXCLUSIVE OR AND
	AS	D	;ADD TO CHECK FOR ZERO
	BNZ	*+5	;B IF NOT 0
	JMP	START	;RESTART
	PI	PUSHSR	;VALUE
	PI	PULLDC	;OF CURRNT IN DC
	LISU	2	;RESET SCRATCH
	PI	PRTLN	;PRINT THE LINE
	LI	<-1	;IPTO THE 0
	ADC		;ADJUST DC
	LR	A,5	;PUT THE
	ST		;CHAR BACK
	LI	'?	;OUTPUT
	LR	1,A	;A
	PI	TTY0	;?
	PI	PRTSTG	;PRINT REST OF THE LINE
	JMP	START	;RESTART
			;
			;FIND END OF LINE
ENDCR	LR	K,P	;SAVE RETURN
	PI	IGNBK	;GET NEXT CHAR
	CI	$0D	;IS IT A CR ?
	BNZ	QWHAT	;B IF NOT
	PK		;RETURN
			;
			;PROCESS A READ
RDATA	LR	K,P	;SAVE RETURN
	PI	PUSHRT
	BR	SETRH	;PROCESS READ-DATA
			;STORES THE RIGHT HAND
			;EXPRESSION IN THE VARIABLE
SETVAL	LR	K,P	;SAVE
	PI	PUSHRT	;RETURN
	PI	CHAR	;GET NEXT CHAR
	PI	TESTVL	;TEST THE VARIABLE
	BM	QWHAT	;B IF NOT THERE
	PI	IGNBK	;GET NEXT CHAR
	CI	'=	;GET PAST EQUAL (1296)
	BNZ	QWHAT	;B NOT THERE (1297)
SETRH	LR	A,5	;SAVE 1ST STRING FLAG
	LR	6,A	;IN R6
	CLR		;CLEAR
	LR	5,A	;STRING FLAG
	XDC		;SAVE
	PI	PUSHDC	;VARIABLE ADDR
	XDC		;TBP BACK IN DC0
	PI	EXPR	;EVALUATE EXPRESSION
	XDC		;SAVE TBP AND GET RH VAR ADDR
	PI	PULLDC	;GET LH VAR ADDR
			;STRING ?
	LR	A,5	;LOAD
	LR	9,A	;RH
	LR	W,J	;STRING FLAG
	LR	A,6	;LOAD
	LR	9,A	;LH STRING FLAG
	BM	SET3	;B IF RH NOT A STRING
	LR	5,A	;SAVE LH STRING FLAG
	LR	W,J	;AND CHECK ITS STATUS
	BP	SET2	;B IF A STRING
SET1	XDC		;GET TBP
	JMP	QWHAT	;ERROR
SET2	XDC		;SAVE
	PI	PUSHDC	;TBP
	XDC		;GET VAR ADDR
	PI	BUFTOV	;MOVE THE STRING
	PI	PULLDC	;RESTORE TBP
	BR	SETR	;RETURN
SET3	LR	W,J	;GET LH STRING FLAG
	BP	SET1	;ERROR IF A STRING
SET4	LR	A,I	;STORE
	ST		;VALUE
	LR	A,D	;IN
	ST		;VARIABLE
	XDC		;RESTORE TBP
SETR	JMP	PULLRT	;RETURN
			;
			;CHECK SIGN OF NUMBER IN 20-21
			;R8=0 FOR + AND '-' FOR -
CHKSGN	LISL	0	;ISAR TO 20
	CLR		;ZERO
	LR	8,A	;ZERO FOR +
	AS	S	;ADD HI ORDER BYTE
	BP	CHG2	;B IF 0 OR -
CHGSGN	LISL	1	;LOAD LOW
	LR	A,S	;ORDER
	COM		;TWO'S
	INC		;COMPLEMENT
	LR	D,A	;BACKIN 21
	LR	J,W	;SAVE STATUS
	LR	A,S	;LOAD HI
	COM		;COMPLEMENT
	LR	W,J	;RESTORE STATUS
	BNC	CHG1	;B IF NO ADJUST
	INC		;ADJUST IF NO CARRY
CHG1	LR	S,A	;SAVE IN R20
	LI	'-	;LOAD A MINUS
	LR	8,A	;INTO R8
CHG2	POP		;RETURN
			;
			;SCRATCH (20-21)-(20-21)-(22-23)
SUBD	LISL	3	;SET ISAR
	LR	A,S	;LOAD
	COM		;MAKE IT
	INC		;A MINUS
	LISL	1	;GET OTHER LOW ORDER
	AS	S	;ADD IT
	LR	J,W	;SAVE STATUS
	LR	I,A	;SAVE 21 MINUS 23
	LR	A,D	;LOAD HI ORDER
	COM		;COMPLEMENT
	LR	W,J	;RESTORE CARRY STATUS
	BNC	NCS	;B IF THERE WAS A CARRY
	INC		;MAKE 2'S COMPLEMENT IF NO CARRY
NCS	LISL	0	;SET TO HI ORDER
	AS	S	;ADD HI ORDER
	LR	S,A	;SAVE IT AND SET LISL 0
	POP		;RETURN
			;
			;SCRATCH (20-21)=(20-21)+(22-23)
			;MULT IS AN ADDITIONAL ENTRY
			;SCRATCH (20-21)-(22-23)*R3
			;20-21 SHOULD BE ZERO FOR A MULT ENTRY
MTPLY	CLR		;CHECK FOR
	AS	7	;A ZERO
	BR	MUL1	;MULTIPLIER (1383)
ADDD	LIS	1	;FOR ADD
	LR	7,A	;FOR ADD ENTRY OVERRIDE MULT
MULT	LISL	3	;SET ISAR
	LR	A,S	;LOAD 23
	LISL	1	;ADD
	AS	S	;21 TO IT
	LR	I,A	;SAVE
	LR	A,D	;LOAD 22
	LNK		;ADD CARRY
	LISL	0	;ADD
	AS	S	;20
	LR	S,A	;SAVE NEW 20
	DS	7	;DEC MULTIPLIER
MUL1	BNZ	MULT	;B IF A MULTIPLY
	CLR		;RESET
	AS	S	;STATUS
	POP		;RETURN WITH LISL 0
			;
			;DIVIDE SCRATCH (20-21) BY (22-23)
			;RESULT IN SCRATC (24-25)
			;REMAINDER IN SCRATCH (20-21)
DIVIDE	LR	K,P	;SAVE RETURN
	PI	PUSHRT	;SAVE RETURN
	PI	PUSH20	;SAVE 20-21
	LR	A,I	;SET
	LR	D,A	;21=20
	CLR		;SET
	LR	S,A	;20=0
	PI	DV1	;DO 1ST PASS
	LR	A,1	;SET
	LR	S,A	;SCRATCH 24=1ST DIGIT
	LISL	1	;SAVE
	LR	A,D	;21
	LR	1,A	;IN R1
	PI	PULLSR	;RESTORE (20-21)
	LR	A,1	;SETUP REMAINDER
	LR	S,A	;IN 20
	BR	DV2	;B AROUND ENTRY
DV1	LR	K,P	;SAVE RETURN
	PI	PUSHRT	;PUSH RETURN
DV2	LI	<-1	;SET
	LR	1,A	;DIGIT COUNTER-1
DV3	LR	A,1	;LOAD AND
	INC		;INCREMENT
	LR	1,A	;DIGIT
	PI	SUBD	;SUBTRACT
	BP	DV3	;B IF NOT LT 0
	PI	ADDD	;ADJUST FOR PAST ZERO
	LISL	5	;LOAD LOW
	LR	A,1	;ORDER RESULT INTO
	LR	D,A	;SCRATCH 25 AND LISL 24
	JMP	PULLRT	;RETURN
			;
			;COMPARE STACK TOP TO SCRATCH 20-21
			;STACK TOP < 20-21 USE BNC(-)
			;STACK TOP = 20-21 USE BZ
			;STACK TOP > 20-21 USE BZ AND THEN BCC+
			;PULLS VALUE OFF OF STACK
COMP	LR	H,DC	;SAVE DC
COMX	LISL	0	;GET LOW ISAR
COMT	LR	DC,Q	;GET STACK POINTER
	LR	A,I	;LOAD HI ORDER BYTE
	CM		;STACK HI - 20
	BNZ	COM1	;B IF NOT EQUAL
	LR	A,D	;LOAD LOW
	CM		;STACK LOW-21
COM1	LR	J,W	;SAVE STATUS
	LR	DC,Q	;LOAD STACK ADDR
	LM		;TAKE LAST ITEM
	LM		;OFF OF THE STACK
	LR	Q,DC	;SAVE NEW POINTER
	LR	DC,H	;RESTORE DC
	LISL	0	;RESET ISAR
	POP		;RETURN
			;
SKIP	LM		;SKIP THIS BYTE
CHAR	LR	H,DC	;SAVE DC
	LM		;GET NEXT CHAR
	CI	' 	;BLANK ?
	BZ	CHAR	;B IF A BLANK
	LR	4,A	;GET LAST DC
	LR	DC,H	;GET DC0 OF LOADED BYTE
	POP		;RETURN
			;
			;FIND NEXT NON BLANK CHAR STARTING AT DC
IGNBK	LR	H,DC	;SAVE TBP
IGN1	LM		;LOAD A CHAR (1470)
	CI	' 	;SEE IF A BLANK (1471)
	BZ	IGN1	;B IF A BLANK
	LR	4,A	;SAVE CHARACTER
	POP		;RETURN WITH CHAR IN ACCUM
			;EXCHANGE TOP OF STACK & ISAR
			;R7-8 ALSO SET TO SCRATCH VALUE
EXCH	LISL	0	;SET ISAR
	LR	K,P	;SAVE RETURN
	LR	A,I	;HI
	LR	6,A	;IN R6
	LR	A,D	;LOW
	LR	7,A	;IN R7
	PI	PULLSR	;PUT STACK IN SCRATCH
	LISU	0	;NOW
	LISL	6	;PUT
	PI	PUSHSR	;SCRATCH ON THE STACK
	LISU	2	;RESET
	LISL	0	;ISAR
	PK		;RETURN
			;
			;MOVE 20-21 TO 22-23
MV2021	LISL	0	;SET ISAR
	LR	A,I	;LOAD 20
	LISL	2	;SET TO 22
	LR	D,A	;INTO 22
	LR	A,I	;LOAD 21
	LISL	3	;SET TO 23
	LR	I,A	;INTO 23
	LISL	0	;RESET ISAR
	POP		;RETURN
			;
			;MOVE DATA FROM HI TO LOW CORE
			;DC1=ADDR+1 OF LAST BYTE STORED
MVUP	LR	H,DC	;SAVE FROM
	LR	DC,Q	;GET STACK ADDR
	LR	A,10	;COMPARE
	CM		;HI BYTE
	BNZ	MV1	;B IF NOT EQ
	LR	A,11	;COMPARE LOW
	CM		;BYTE
	BZ	MV2	;B IF THE END
MV1	LR	DC,H	;RESTORE FROM
	LM		;LOAD A BYTE
	XDC		;GET TO
	ST		;STORE IT
	XDC		;RESTORE FROM
	BR	MVUP	;GET NEXT BYTE
MV2	POP		;RETURN
			;
			;DC0=FROM, DC1=TO, STACK END=TOP
			;THE TOP OF THE STACK IS COMPARED
			;TO THE 'FROM' ADDR AFTER EACH MOVE.
			;MOVE DATA FROM LOW TO HI CORE
			;H WILL HAVE THE ADDR OF THE LAST BYTE
			;THAT WAS MOVED
MVDOWN	LR	H,DC	;SAVE DC
	LR	DC,Q	;STACK TOP ADDR
	LR	A,10	;COMPARE
	CM		;1ST BYTE
	BNZ	MVD1	;B IF NOT EQUAL
	LR	A,11	;COMPARE
	CM		;2ND BYTE
MVD1	LR	J,W	;SAVE STATUS
	LR	DC,H	;RESTORE PRESENT FROM
	LM		;LOAD A BYTE
	XDC		;GET TO
	ST		;STORE
	LI	<-2	;ADJUST
	ADC		;TO
	XDC		;ADJUST
	ADC		;FROM
	LR	W,J	;RESTORE STATUS
	BNZ	MVDOWN	;B IF NOT THE END
	POP		;RETURN
			;
			;MOVE A STRING FROM BUFF TO THE
			;VARIABLE ADDR.  DC0=VAR ADDR
			;TBP IS ON THE STACK
BUFTOV	LR	K,P	;SAVE RETURN
	CLR		;ZERO ACCUM
	LR	W,J	;GET STATUS
	BNZ	BU0	;B IF A-Z
	LM		;ADJUST ARRAY ADDR
	LISL	6	;SET ISAR TO @ TYPE
	PI	PUSHSR	;PUT TXTU ON THE STACK
	LI	<-2	;GET VAR
BU0	LR	7,A	;ADJUST (1557)
	XDC		;SAVE VAR ADDR (1558)
	BZ	BU1	;B IF @
	DCI	STRLGH	;PUT THE
	PI	PUSHDC	;END ADDR OF
BU1	PI	PULL20	;A-Z IN 20-21
	LIS	13	;SET (CR) AS
	LR	1,A	;AS THE TERMINATOR
	DCI	BUFF	;GET THE
	PI	CHAR	;FIRST CHAR
	LI	72	;SETUP
	LR	2,A	;LENGTH COUNTER
BU2	LM		;LOAD A CHAR
	LR	6,A	;SAVE IT
	XS	1	;(CR) ?
	XDC		;GET VAR ADDR
	BZ	BU7	;B IF END OF STRING
	CLR		;SEE IF
	AS	6	;A NUL END
	BZ	BU7	;WAS USED
	PI	PUSHDC	;PUT ADDR ON STACK
	PI	COMT	;TATU-@ OR STRLGH-(A-Z)
	LR	A,5	;VAR TYPE
	LR	9,A	;INTO R9
	BNC	BU5	;B IF COMPARE WAS -
			;IF @ WE ARE OK
	LR	W,J	;VAR TYPE
	BNZ	BU4	;B IF A-Z, AN ERROR
	BR	BU6	;CONTINUE
			;IF A-Z WE ARE OK
BU5	LR	W,J	;VAR TYPE
	BZ	BU4	;B IF @, AN ERROR
BU6	LR	A,6	;RESTORE CHAR
	SL	1	;MAKE SURE
	SR	1	;NO FALSE END
	LR	8,A	;SAVE THE CHAR
	LR	H,DC	;AND THE ADDR
	ST		;STORE CHAR
	LR	A,7	;ADJUST
	ADC		;VAR ADDR
	XDC		;RESTORE FROM
	DS	2	;CHECK STRING LENGTH
	BNZ	BU2	;B IF MORE ROOM
BU4	JMP	AHOW	;NO MORE ROOM
BU7	LR	A,8	;RESTORE LAST CHAR
	LR	DC,H	;AND ITS ADDR
	OI	$80	;OF STRING
	ST		;FLAG
	LR	A,2	;SEE IF
	SR	1	;THE STRING
	SL	1	;LENGTH IS
	XS	2	;ODD OR EVEN
	BZ	BU8	;B IF EVEN
	LR	A,7	;ADJUST
	ADC		;VAR ADDR
	LR	A,8	;LOAD THE LAST CHAR
	ST		;ODD,FILL THE WORD
BU8	PI	SLEN	;GET THE LENGTH
	PK		;RETURN
			;
			;R2 HAS A DECREMENTED COUNTER
			;COMPLEMENT IT AND ADD START LE
SLEN	LR	A,2	;MAKE
	COM		;COUNTER
	INC		;NEGATIVE
	AI	72	;ADD ORIGINAL LENGTH
	DCI	STRLGH	;STORE
	ST		;LENGTH
	POP		;RETURN
			;
			;SCRATCH 36-37 LOPVAR GOES ON
SAVE	XDC		;SAVE TBP
	LR	K,P	;SAVE RETURN
	DCI	SKEND	;STACK LIMIT ADDR
	PI	PUSHDC	;SAVE END OF STACK
	LISU	1	;SET ISAR
	LISL	6	;TO Q REGS
	PI	COMT	;SKIP LISL 0
	BM	SAV1	;B IF ROOM LEFT
	XDC		;GET TBP
	JMP	QSORRY	;PROCESS ERROR
SAV1	LISU	3	;SETUP ISAR
	LISL	6	;SET RO LOPVA
	LR	A,I	;LOOP VARIABLE ADDR
	XS	S	;XOR AND ADD
	AS	D	;TO CHECK FOR ZERO
	BZ	SAV3	;B IF ZERO
	LR	DC,Q	;GET STACK ADDR(1644)
	LI	<-8	;MAKE ROOM(1645)
	ADC		;FOR 4 ITEMS ON THE STACK
	LR	Q,DC	;SAVE STACK
	LISU	4	;SAVE THE REST
	LISL	0	;OF THE VARIABLES
	LIS	8	;SETUP
	LR	1,A	;LOOP
SAV2	LR	A,I	;SAVE
	ST		;FOR VARIABLES
	DS	1	;DEC COUNTER
	BNZ	SAV2	;LOOP IF NOT DONE
	LISU	3	;PUT
	LISL	6	;LOPVAR ON
SAV3	PI	PUSHSR	;ON THE STACK TOP
	XDC		;RESTORE TBP
	LISU	2	;RESTORE ISAR
	PK		;RETURN
			;
			;RESTORE FOR VARIABLES
			;LOPVAR IS ON THE STACK TOP
RESTOR	LISU	3	;SET
	LISL	6	;ISAR
	LR	DC,Q	;GET STACK POINTER
	LM		;RESTORE
	LR	I,A	;LOPVAR
	LM		;FROM
	LR	D,A	;STACK TOP
	XS	S	;XOR AND
	AS	S	;ADD TO SEE IF ZERO
	BZ	RES2	;B IF ZERO
REFOR	LISU	4	;SET
	LISL	0	;ISAR
	LIS	8	;SETUP
	LR	1,A	;LOOP
RES1	LM		;LOAD
	LR	I,A	;LOOP VARIABLES
	DS	1	;DEC COUNTER
	BNZ	RES1	;LOOP IF NOT DONE
RES2	LR	Q,DC	;RESTORE STACK
	LISU	2	;RESET ISAR
	POP		;RETURN
			;
			;PUSH DC ON TO STACK
PUSHDC	LR	H,DC	;SAVE CURRENT DC
	LR	DC,Q	;STACK POINTER
	LI	<-2	;THE STACK POINTER
	ADC		;2 BYTES
	LR	Q,DC	;SAVE STACK POINTER
	LR	A,10	;SAVE
	ST		;HI
	LR	A,11	;SAVE
	ST		;LOW
	LR	DC,H	;RESTORE DC
	POP		;RETURN
			;
			;PULL DC FROM STACK
PULLDC	LR	DC,Q	;BACK UP
	LM		;LOAD
	LR	10,A	;HI
	LM		;LOW
	LR	11,A	;LOAD
	LR	Q,DC	;SAVE NEW POINTER
	LR	DC,H	;INTO DC
	POP		;RETURN
			;
			;SAVE 2 SCRATCH BYTES ON THE STACK
			;LISL REMAINS THE SAME
PUSH20	LISL	0	;SPECIAL ENTRY FOR 20-21
PUSHSR	LR	H,DC	;SAVE DC
	LR	DC,Q	;GET STACK POINTER
	LI	<-2	;BACK UP TWO
	ADC		;BYTES
	LR	Q,DC	;SAVE STACK POINTER
	LR	A,I	;LOAD 1ST BYTE
	ST		;SAVE IT
	LR	A,D	;LOAD 2ND BYTE
	ST		;SAVE
	LR	DC,H	;RESTORE DC
	POP		;RETURN
			;
			;PULL 2 BYTES FROM STACK INTO SCRATCH
			;LISL REMAINS THE SAME
PULL20	LISL	0	;SPECIAL ENTRY FOR 20-21
PULLSR	LR	H,DC	;SAVE DC
	LR	DC,Q	;LOAD STACK POINTER
	LM		;LOAD
	LR	I,A	;INTO SCRATCH(1731)
	LM		;LOAD 2ND(1732)
	LR	D,A	;INTO SCRATCH
	LR	Q,DC	;SAVE POINTER
	LR	DC,H	;RESTORE DC
	POP		;RETURN
			;
			;SAVE RETURN (KU-KL) ON STACK
			;CALLING FORMAT IS
			;LR	K,P
			;PI	PUSHRT
PUSHRT	LR	H,DC	;SAVE DC
	LR	DC,Q	;GET STACK POINTER
	LI	<-2	;BACK UP 2
	ADC		;BYTES TO LAST ENTRY
	LR	Q,DC	;SAVE POINTER
	LR	A,KU	;STORE
	ST		;HIGH
	LR	A,KL	;STORE
	ST		;LOW
	LR	DC,H	;RESTORE DC
	POP		;RETURN
			;
			;PULL RETURN FROM STACK AND RETUDN
			;TO THE ADDR THAT WAS PULLED FROM THE
			;STACK WITH A PK
PULLRT	LR	H,DC	;SAVE DC
	LR	DC,Q	;GET STACK POINTER
	LM		;LOAD HI
	LR	KU,A	;ORDER INTO KU
	LM		;LOAD LOW
	LR	KL,A	;ORDER INTO KL
	LR	Q,DC	;SAVE UPDATED POINTER
	LR	DC,H	;RESTORE DC
	PK		;RETURN TO PULLED RETURN ADDR
			;
			;PULLS RETURN OFF STACK INTO K
POPRT	LR	H,DC	;SAVE DC
	LR	DC,Q	;GET STACK POINTER
	LM		;LOAD
	LR	KU,A	;THE
	LM		;RETURN
	LR	KL,A	;ADDR
	LR	Q,DC	;RESTORE IT
	LR	DC,H	;RESTORE DC
	POP		;RETURN
			;
			;CALL A.L. ROUTINE
USR	PI	EXPR	;GET ADDR
	PI	PUSHDC	;SAVE TBP
			;CALLED ROUTINE SHOULD SAVE RETURN
	LR	A,I	;LOAD HI CALL BYTE
	LR	KU,A	;INTO KU
	LR	A,D	;LOW CALL BYTE
	LR	KL,A	;INTO KL
	PK		;CALL THE ROUTINE
	PI	PULLDC	;RESTORE TBP
	JMP	FIN	;FINISH UP
			;
			;PUT A VALUE IN MEMORY
			;POKE ADDR,VALUE
POKE	PI	EXPR	;GET POKE ADDR
	PI	PUSH20	;SAVE IT
	PI	IGNBK	;GET NEXT CHAR
	CI	',	;COMMA ?
	BNZ	POK1	;B IF NOT A COMMA
	PI	EXPR	;GET NEXT EXPR
	XDC		;SAVE TBP
	PI	PULLDC	;GET POKE ADDR
	LISL	1	;STORE
	LR	A,D	;THE
	ST		;VALUE (2ND BYE OF THE WORD)
	XDC		;RESTORE TBP
	JMP	FIN	;FINISH UP
POK1	JMP	QWHAT	;ERROR
			;
			;PROCESS 'LITERAL'
			;PUT INTO BUFF AND 1ST 2 CHARS IN
APOST	LI	''	;SETUP
	BR	AQ1	;THE
QUOTE	LI	'"	;LITERAL
AQ1	LR	1,A	;END CHAR
	XDC		;SAVE TBP
	DCI	BUFF	;GET TARGET
	LI	72	;GET
	LR	2,A	;MAX LENGTH
AQ2	XDC		;GET TBP
	LM		;LOAD A CHAR(1818)
	XDC		;GET PRESENT BUFF ADDR
	LR	H,DC	;SAVE PRESENT BUFF ADDR
	ST		;STORE CHAR
	XS	1	;LAST ONE?
	BZ	AQ3	;B IF IT IS
	DS	2	;ROOM LEFT ?
	BR	AQ2	;CONTINUE
AQ3	LR	DC,H	;A ZERO TERMINATOR
	ST		;TO MARK END OF STRING
	DCI	BUFF	;PUT THE
	LISL	0	;FIRST
	LM		;AND
	LR	4,A	;SECOND
	LR	I,A	;CHARS
	LM		;IN
AQ4	LR	S,A	;20-21
	XS	1	;WAS THERE JUST
	LR	A,4	;ONE CHAR ?
	BZ	AQ4	;IF ONLY 1 REPEAT IT IN 21
	LISL	0	;RESET ISAR
	PI	SLEN	;SETUP STRING LENGTH
	LIS	1	;SET STATUS
	LR	5,A	;TO STRING
	XDC		;RESTORE TBP
	PI	CHAR	;GET NEXT CHAR
	JMP	PULLRT	;RETURN
			;
			;GET STRING LENGTH OF VARIABLE
			;IF THE ARG=0 GET LAST LENGTH
LEN	PI	PARN	;EVALUATE ARG
	XDC		;SAVE TBP, GET VAR ADDR
	CLR		;ZERO HI
	LR	5,A	;ZERO STRING FLAG
	LR	I,A	;BYTE
	DCI	STRLGH	;PUT THE
	LM		;STRING LENGTH
	LR	D,A	;INTO 20-21
	XDC		;RESTORE TBP
	JMP	PULLRT	;RETURN
			;
			;ABSOLUTE VALUE
ABS	PI	PARN	;ABS(EXPR)
	PI	CHKSGN	;CHECK SIGN
	LR	A,S	;SEE IF
	CI	$80	;-32768
	BZ	JMPHOW	;B IF IT IS
	JMP	PULLRT	;RETURN
			;
			;RANDOM NUMBER
RND	PI	PARN	;RND(EXPR)
	LR	A,S	;EXPR
	AS	S	;MUST BE PLUS
	BM	JMPHOW	;B IF -
	LR	A,I	;SEE IF ZERO
	XS	S	;BY XORING
	AS	D	;AND ADDING
	BZ	JMPHOW	;B IF ZERO
	PI	PUSHSR	;SAVE EXPR
	XDC		;AND TBP
	DCI	RANPNT	;GET LAST ADDR
	PI	PUSHDC	;ON THE STACK
	LM		;LOAD CONTENTS
	LR	10,A	;SAVE HI ADDR
	LR	I,A	;OF
	LM		;RANDOM MEMORY
	LR	11,A	;SAVE LOW ADDR
	LR	D,A	;INTO 20-21
	PI	COMX	;SKIP LR H,DC
	BC	RN1	;B IF NOT LAST ADDR
	DCI	START	;WRAP AROUND ADDR
RN1	LM		;PUT
	LR	I,A	;CONTENT OF
	LM		;ADDR IN RANPNT
	LR	I,A	;INTO 20-21
	LR	H,DC	;NEW RANPNT ADDR ADDR
	DCI	RANPNT	;GET TARGET
	LR	A,10	;STORE
	ST		;IT
	LR	A,11	;IN
	ST		;RANPNT
	PI	PULLSR	;ARG INTO 22-23
	PI	CHKSGN	;CHECK SIGN OF RANDOM NUMBER
	PI	DIVIDE	;RANNUM/INPUT #
	LISL	1	;ADD
	LR	A,S	;ONE
	INC		;TO THE
	LR	D,A	;REMAINDER(1905)
	LR	A,S	;ADD IN
	LNK		;ANY
	LR	S,A	;CARRY
	XDC		;RESTORE TBP
	JMP PULLRT	;RETURN
			;
			;VAL=PEEK(ADDR)
			;SET VAL TO THE BYTE AT ADDR
PEEK	PI	PARN	;GO GET ADDR IN 20-21
	XDC		;SAVE TBP
	LR	A,I	;LOAD
	LR	10,A	;PEEK
	LR	A,S	;ADDR
	LR	11,A	;INTO
	LR	DC,H	;DC
	LM		;LOAD BYTE
	LR	D,A	;INTO 21
	CLR		;ZERO
	LR	S,A	;20
	XDC		;RESTORE TBP
	JMP	PULLRT	;RETURN
			;
			;TAB(X) SPACE OVER TO COLUMN X
TAB	PI	PARN	;EVALUATE THE EXPRESSION
	LR	A,I	;SEE IF
	XS	S	;ZERO BY XOR
	AS	S	;AND ADDING
	BZ	JMPHOW	;B IF ZERO AN ERROR
	LR	A,D	;LOAD THE NUMBER OF BLANKS TO PRINT
	LR	8,A	;INTO RP
TA1	PI	PBLK	;PRINT A BLANK
	DS	8	;DEC LOOP COUNTER
	BNZ	TA1	;B IF MORE
	CLR		;SETUP DUMMY
	BR	CH1	;STRING FOR PRINT
JMPHOW	JMP	QHOW	;ERROR
			;
			;CHR(X) OUTPUT ASCII CODE X
CHR	PI	EXPR	;GET ASCII
	LISL	1	;CODE
	LR	A,D	;INTO
CH1	LR	H,DC	;SAVE TBP
	DCI	BUFF	;BUFF
	ST		;AND
	CLR		;MARK
	ST		;END
	INC		;AND
	LR	5,A	;SET STRING FLAG
	LR	DC,H	;RESTORE TBP
	JMP	PULLRT	;RETURN
			;
H8000	EQU	$8000
TAB1	EQU	*	;DIRECT COMMANDS
	DC	"LIST"
	DC.W	LIST+H8000
	DC	"NEW"
	DC.W	NEW+H8000
	DC	"RUN"
	DC.W	RUN+H8000
;	DC	"MON"
;	DC.W	MON+H8000
TAB2	EQU	*	;DIRECT/STATEMENT
	DC	"LET"
	DC.W	LET+H8000
	DC	"IF"
	DC.W	IF+H8000
	DC	"GOTO"
	DC.W	GOTO+H8000
	DC	"FOR"
	DC.W	FOR+H8000
	DC	"NEXT"
	DC.W	NEXT+H8000
	DC	"GOSUB"
			;
	DC.W	GOSUB+H8000
	DC	"RETURN"
			;
	DC.W	RETURN+H8000
	DC	"PRINT"
			;
	DC.W	PRINT+H8000
	DC	"INPUT"
			;
	DC.W	INPUT+H8000
	DC	"THEN"
	DC.W	GOTO+H8000	;PROCESS LIKE GOTO
	DC	"REM"		;(1992)
	DC.W	REM+H8000	;(1993)
	DC	"READ"
	DC.W	READ+H8000
	DC	"DATA"
	DC.W	DATA+H8000
	DC	"USR"		;USER CALLED ROUTINE
	DC.W	USR+H8000
	DC	"POKE"		;POKE X,Y
	DC.W	POKE+H8000
	DC	"RESTORE"
			;
	DC.W	RESTORE+H8000
	DC	"STOP"
	DC.W	STOP+H8000
	DC.W	DEFLT+H8000
TAB4	EQU	*		;FUNCTIONS
	DC	"RND"		;RND(X)
	DC.W	RND+H8000
	DC	"ABS"		;ABS(X)
	DC.W	ABS+H8000
	DC	"PEEK"		;PEEK IN TO CORE
	DC.W	PEEK+H8000
	DC	"LEN"		;GET THE STRING LENGTH
	DC.W	LEN+H8000
	DC	''		;'LITERAL'
	DC.W	APOST+H8000
	DC	'"		;"LITERAL"
	DC.W	QUOTE+H8000
	DC	"TAB"		;TAB(X)
	DC.W	TAB+H8000
	DC	"CHR"		;CHR(X)
	DC.W	CHR+H8000
	DC.W	XP40+H8000
TAB5	EQU	*		;'TO' IN 'FOR'
	DC	"TO"
	DC.W	FR1+H8000
	DC.W	QWHAT+H8000
TAB6	EQU	*		;'STEP' IN 'FOR'
	DC	"STEP"
	DC.W	FR2+H8000
	DC.W	FR3+H8000
TAB8	EQU	*		;RELATIONAL OPERATORS
	DC	">="		;GREATER THAN OR EQUAL TO
	DC.W	XP11+H8000
	DC	"#"		;NOT EQUAL TO
	DC.W	XP12+H8000
	DC	">"		;GREATER THAN
	DC.W	XP13+H8000
	DC	"="		;EQUAL
	DC.W	XP15+H8000
	DC	"<="		;LESS THAN OR EQUAL TO
	DC.W	XP14+H8000
	DC	"<"		;LESS THAN
	DC.W	XP16+H8000
	DC.W	XP17+H8000
PROMPT	DC	"READY"
	DC	$0D
;
;	IO JUMP TABLE
TTY0	LR	A,1	;OUTPUT BYTE IN ACCUM
	CI	$0D	;CR ?
	BZ	TTCR	;B IF YES
;
;	OUTPUT A CHARACTOR
TTY1	LR	H,DC	;SAVE CURRENT DC
	LR	DC,Q	;STACK POINTER
	LI	<-2	;THE STACK POINTER
	ADC		;2 BYTES
	LR	Q,DC	;SAVE STACK POINTER
	LR	A,10	;SAVE
	ST		;HI
	LR	A,11	;SAVE
	ST		;LOW
	LR	DC,H	;RESTORE DC
;
LTTY1	DCI	UARTC	;8251 CONTROL REGISTER
	LM		;GET STATUS
	NI	$01	;CHECK TX ENABLE
	BZ	LTTY1	;IF NOT, REPEAT
	DCI	UARTD	;8251 DATA REGISTER
	LR	A,1	;SET CHARACTOR
	ST		;WRITE
;
	LR	DC,Q	;BACK UP
	LM		;LOAD
	LR	10,A	;HI
	LM		;LOW
	LR	11,A	;LOAD
	LR	Q,DC	;SAVE NEW POINTER
	LR	DC,H	;INTO DC
;
	POP		;RETURN
;
;	INPUT A CHARACTOR
TTYI	LR	H,DC	;SAVE CURRENT DC
	LR	DC,Q	;STACK POINTER
	LI	<-2	;THE STACK POINTER
	ADC		;2 BYTES
	LR	Q,DC	;SAVE STACK POINTER
	LR	A,10	;SAVE
	ST		;HI
	LR	A,11	;SAVE
	ST		;LOW
	LR	DC,H	;RESTORE DC
;
TYI1	DCI	UARTC	;8251 CONTROL REGISTER
	LM		;GET STATUS
	NI	$02	;CHECK RX DONE
	BZ	TYI1	;IF NOT, REPEAT
	DCI	UARTD	;8251 DATA REGISTER
	LM		;GET CHARACTOR
	LR	1,A	;SET CHARACTOR
;
	LR	DC,Q	;BACK UP
	LM		;LOAD
	LR	10,A	;HI
	LM		;LOW
	LR	11,A	;LOAD
	LR	Q,DC	;SAVE NEW POINTER
	LR	DC,H	;INTO DC
;
	LR	A,1	;LOAD LEAD CHARACTER
	CI	'a-1	;IF a-z
	BC	TYI2
	CI	'z
	BNC	TYI2
	NI	$DF	;CONVERT A-Z
	LR	1,A	;REPLACE CHARACTOR
TYI2	POP		;RETURN
;
;	OUTPUT CR,LF
TTCR	LR	K,P	;SAVE RETURN ADDRESS
	LIS	$0D	;SET CR TO A
	LR	1,A	;SET CAHRACTOR TO SCRATCHPAD01
	PI	TTY1	;CALL TTY1
	LIS	$0A	;SET LF TO A
	LR	1,A	;SET CAHRACTOR TO SCRATCHPAD01
	PI	TTY1	;CALL TTY1
	PK		;RETURN
;
;MON	JMP	$8080
;
	ORG	RAMTOP
RANPNT	EQU	*		;RANDOM NUMBER POINTER
	ORG	RANPNT+2	;RANDOM NUMBER POINTER
TXTB	EQU	*		;BEGIN OF TEXT AREA
	ORG	TXTB+$7000	;CHANGE IN MULTIPLES OF 256 BYTES
TXTE	EQU	*		;END OF TEXT AREA
VARBGN	EQU	*		;@(0) LOCATION
	ORG	VARBGN+54
STRLGH	EQU	*		;STRING LENGTH
	ORG	STRLGH+1
BUFF	EQU	*		;BUFFER FOR 72 INPUT BYTES
	ORG	BUFF+73
SKEND	EQU	STACK-128	;END OF STACK
STACK	EQU	$FF00		;BEGIN OF STACK
;
	END		;(2069)
